uniform float u_rayStrength;
uniform float u_raySize;


varying vec2 v_texCoord;
varying vec2 v_diffTexCoord;


void main()
{
    vec4 attCol = texture2D(CC_Texture1, v_diffTexCoord);
    float weight = step(0.001, attCol.g);
    vec4 finalColor = vec4(0.0);
    if (attCol.g > 0.001){
        
        float edge = 1.0 + attCol.b * 0.25;
        vec4 fluidCol = mix(vec4(0.2, 0.32, 0.8, 0.7), vec4(0.14, 0.74, 1.0, 0.7), v_texCoord.y) * edge;
        vec4 outCol = mix(vec4(0.0), fluidCol, weight);
        
        vec2 raysUV = v_texCoord * u_raySize;
        vec4 raysACol = texture2D(CC_Texture2, raysUV);
        
        raysUV.x = mod(v_texCoord.x * u_raySize + 0.25, 1.0);
        vec4 raysBCol = texture2D(CC_Texture2, raysUV);
        
        outCol.rgb += raysACol.rgb * u_rayStrength * u_raySize + raysBCol.rgb * (1.0 - u_rayStrength) * u_raySize;
        finalColor = outCol;
    }
    gl_FragColor = finalColor;
} 
